package forestry.apiculture.blocks;

import javax.annotation.Nullable;

import com.google.common.base.Predicate;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.api.core.Tabs;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.blocks.IBlockWithMeta;
import forestry.core.blocks.IColoredBlock;
import forestry.core.config.Config;
import forestry.core.config.Constants;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockHoneyComb extends Block implements IItemModelRegister, IBlockWithMeta, IColoredBlock, IStateMapperRegister {
	public final int minMeta;
	
	public static final BlockHoneyComb[] create(){
		BlockHoneyComb[] blocks = new BlockHoneyComb[2];
		for(int i = 0;i < blocks.length;i++){
			HoneyCombPredicate filter = new HoneyCombPredicate(i, 16);
			PropertyEnum<EnumHoneyComb> variant = PropertyEnum.func_177708_a("type", EnumHoneyComb.class, filter);
			blocks[i] = new BlockHoneyComb(filter.minMeta) {
				@Override
				protected PropertyEnum<EnumHoneyComb> getVariant() {
					return variant;
				}
			};
		}
		return blocks;
	}
	
	public BlockHoneyComb(int minMeta) {
		super(Material.field_151580_n);
		func_149711_c(1F);
		func_149647_a(Tabs.tabApiculture);
		func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(getVariant(), getVariant().func_177700_c().iterator().next()));
		this.minMeta = minMeta;
	}
	
	protected abstract PropertyEnum<EnumHoneyComb> getVariant();

	@Override
	protected BlockStateContainer func_180661_e() {
		return new BlockStateContainer(this, getVariant());
	}

	@Override
	public int func_176201_c(IBlockState state) {
		return state.func_177229_b(getVariant()).ordinal()-minMeta;
	}

	@Override
	public IBlockState func_176203_a(int meta) {
		return func_176223_P().func_177226_a(getVariant(), EnumHoneyComb.get(minMeta + meta));
	}

	@Override
	public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
		for (EnumHoneyComb honeyComb : getVariant().func_177700_c()) {
			if(!honeyComb.isSecret() || Config.isDebug){
				list.add(get(honeyComb));
			}
		}
	}
	
	@Override
	public String func_149739_a() {
		return "tile.for.bee_combs";
	}
	
	@SideOnly(Side.CLIENT)
	@Override
	public BlockRenderLayer func_180664_k() {
		return BlockRenderLayer.CUTOUT;
	}

	@Override
	public int func_180651_a(IBlockState state) {
		return func_176201_c(state);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModel(Item item, IModelManager manager) {
		for (EnumHoneyComb comb : getVariant().func_177700_c()) {
			manager.registerItemModel(item, comb.ordinal()-minMeta, "block_bee_combs");
		}
	}

	public ItemStack get(EnumHoneyComb honeyComb) {
		return new ItemStack(this, 1, honeyComb.ordinal() - minMeta);
	}

	@Override
	public String getNameFromMeta(int meta) {
		EnumHoneyComb honeyComb = EnumHoneyComb.get(minMeta + meta);
		return honeyComb.name;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public int colorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
		int meta = func_176201_c(state);
		EnumHoneyComb honeyComb = EnumHoneyComb.get(minMeta + meta);
		if (tintIndex == 1) {
			return honeyComb.primaryColor;
		} else {
			return honeyComb.secondaryColor;
		}
	}
	
	@SideOnly(Side.CLIENT)
	@Override
	public void registerStateMapper() {
		ModelLoader.setCustomStateMapper(this, new HoneyCombStateMapper());
	}
	
	private static class HoneyCombPredicate implements Predicate<EnumHoneyComb> {
		private final int minMeta;
		private final int maxMeta;

		public HoneyCombPredicate(int blockNumber, int variantsPerBlock) {
			this.minMeta = blockNumber * variantsPerBlock;
			this.maxMeta = minMeta + variantsPerBlock - 1;
		}

		@Override
		public boolean apply(@Nullable EnumHoneyComb honeyComb) {
			return honeyComb != null && honeyComb.ordinal() >= minMeta && honeyComb.ordinal() <= maxMeta;
		}
	}
	
	@SideOnly(Side.CLIENT)
	private static class HoneyCombStateMapper extends StateMapperBase {

		@Override
		protected ModelResourceLocation func_178132_a(IBlockState state) {
			return new ModelResourceLocation(Constants.MOD_ID + ":bee_combs", "normal");
		}
		
	}
}
